package tech.yixiyun.framework.kuafu.boot.bootedhandler;

import java.util.ArrayList;
import java.util.List;

public class BootedHandlerContext {

    private static final List<Class<? extends IBootedHandler>> handlerClasses = new ArrayList<>();

    /**
     * 注册启动后处理器类
     * @param handlerClass
     */
    public static void register(Class<? extends IBootedHandler> handlerClass) {
        handlerClasses.add(handlerClass);
    }


    public static List<Class<? extends IBootedHandler>> getHandlerClasses() {
        return handlerClasses;
    }

}
