package tech.yixiyun.framework.kuafu.boot.server.tomcat;

import org.apache.catalina.LifecycleException;

public class TomcatCloser extends Thread {

    private TomcatStarter starter;
    public TomcatCloser(TomcatStarter starter) {
        this.starter = starter;
    }


    @Override
    public void run() {
        // 在JVM关闭之前执行收尾工作
        // 注意事项：
        // 1.在这里执行的动作不能耗时太久
        // 2.不能在这里再执行注册，移除关闭钩子的操作
        // 3 不能在这里调用System.exit()
        try {
            starter.getContext().stop();
        } catch (LifecycleException e) {
            e.printStackTrace();
        }
        starter.shutdown();
    }

}
