package tech.yixiyun.framework.kuafu.component;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 标记这是一个内置组件，任何类的注解或者接口，如果被@Component标记，
 * 系统启动时，就会将该类自动识别为内置组件，将其注册到BeanContext中
 * @author Yixiyun
 * @date 2021-04-09 14:48
 * @version 1.0
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE, ElementType.ANNOTATION_TYPE})
public @interface Component {
}
