package tech.yixiyun.framework.kuafu.component.register;


import tech.yixiyun.framework.kuafu.controller.PathResolver;
import tech.yixiyun.framework.kuafu.controller.annotation.Controller;
import tech.yixiyun.framework.kuafu.controller.route.RouteContext;
import tech.yixiyun.framework.kuafu.log.LOGGER;

/**
 * Controller类解析器，注意类的可见范围只能在此包内，不能被外部调用，因为这里的逻辑是必须先注册Bean，生成代理类后
 * 才能在解析Controller
 */
public class ControllerComponentRegistrar implements IComponentRegistrar {

    @Override
    public void register(Class clazz) {

        Controller controller = (Controller) clazz.getAnnotation(Controller.class);
        if (controller != null) {

            String basePath = PathResolver.resolve(clazz.getSimpleName(), controller.value());

            LOGGER.trace("Controller注册：" + clazz.getName() + "，basePath：" + basePath);

            RouteContext.register(clazz);

        }
    }


}
