package tech.yixiyun.framework.kuafu.component.register;


import tech.yixiyun.framework.kuafu.component.ComponentResolveException;
import tech.yixiyun.framework.kuafu.db.datasource.DataSourceContext;
import tech.yixiyun.framework.kuafu.db.datasource.DataSourceDefinition;
import tech.yixiyun.framework.kuafu.db.datasource.IDataSourceProvider;

/**
 * IDataSourceProvider类解析器
 */
public class DataSourceComponentRegistrar implements IComponentRegistrar {
    @Override
    public void register(Class clazz) {

        if (IDataSourceProvider.class.isAssignableFrom(clazz)) {
            try {
                IDataSourceProvider provider = (IDataSourceProvider) clazz.newInstance();
                DataSourceDefinition[] definitions = provider.get();
                for (DataSourceDefinition definition : definitions) {

                    DataSourceContext.register(definition);
                }
            } catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException) e;
                }
                throw new ComponentResolveException("根据"+clazz+"注册数据源时发生异常",e) ;
            }
        }
    }
}
