package tech.yixiyun.framework.kuafu.component.register;

/**
 * 组件注册器。框架启动的时候，会将扫描到的所有类，交给注册的组件注册器拿去注册。
 * 注册器的逻辑需要自己实现。例如BeanComponentRegistrar，就负责将所有有@Bean注解的类，注册为Bean。<br/>
 * 如果想注册自己的组件注册器，请通过ComponentManager.addComponentRegistrar接口实现
 * @author Yixiyun
 * @date 2021-04-09 11:06
 * @version 1.0
 */
public interface IComponentRegistrar {
    /**
     * 框架启动时，会将扫描到的类交给组件注册器，由其判断是否是一个组件、是否要注册、怎么注册。
     * @param clazz
     */
    void register(Class clazz);
}
