package tech.yixiyun.framework.kuafu.component.register;


import tech.yixiyun.framework.kuafu.controller.annotation.ContentType;
import tech.yixiyun.framework.kuafu.controller.request.param.ParamValueResolverContext;
import tech.yixiyun.framework.kuafu.controller.request.param.IRequestParamResolver;

/**
 * ParamValueResolver类解析器
 */
public class ParamValueResolverComponentRegistrar implements IComponentRegistrar {
    @Override
    public void register(Class clazz) {

        if (IRequestParamResolver.class.isAssignableFrom(clazz)) {
            ContentType contentType = (ContentType) clazz.getDeclaredAnnotation(ContentType.class);
            String[] types = contentType.value();
            if (contentType == null && types.length==0) {
                throw new RuntimeException(clazz + "未指定注册的ContentType类型");
            }

            ParamValueResolverContext.register(clazz);

        }
    }
}
