package tech.yixiyun.framework.kuafu.component.unregister;


import tech.yixiyun.framework.kuafu.db.datasource.IDataSourceProvider;
import tech.yixiyun.framework.kuafu.log.LOGGER;

/**
 * 数据源提供器注销
 * @author Yixiyun
 * @date 2021-04-10 19:15
 * @version 1.0
 */
public class DataSourceComponentUnregistrar implements IComponentUnregistrar {
    @Override
    public boolean unregister(Class clazz) {

        if (IDataSourceProvider.class.isAssignableFrom(clazz)) {
            LOGGER.warn("请重启程序");
            return false;
        }
        return true;
    }

}
