package tech.yixiyun.framework.kuafu.component.unregister;


import tech.yixiyun.framework.kuafu.controller.interceptor.IControllerInterceptor;
import tech.yixiyun.framework.kuafu.controller.interceptor.InterceptorContext;

/**
 * ControllerInterceptor类解析器
 */
public class InterceptorComponentUnregistrar implements IComponentUnregistrar {
    @Override
    public boolean unregister(Class clazz) {
        if (IControllerInterceptor.class.isAssignableFrom(clazz)) {
            InterceptorContext.unregister(clazz);
        }
        return true;
    }
}
