package tech.yixiyun.framework.kuafu.config;

public class ConfigKey {


    /**
     * 嵌入式服务绑定的端口
     */
    public static final String SERVER_PORT = "system.server.port";
    /**
     * 嵌入式服务使用的协议。默认HTTP/1.1协议
     */
    public static final String SERVER_PROTOCOL = "system.server.protocol";
    /**
     * 服务器收到请求后等待处理的超时时间，默认60s
     */
    public static final String SERVER_CONNECTION_TIMEOUT = "system.server.connectionTimeout";
    /**
     * 服务器对文本输出是否压缩，三个值可用，on代表开启，off关闭，force强制。默认off
     */
    public static final String SERVER_TEXT_COMPRESS = "system.server.compress";
    /**
     * 服务器收到请求后等待处理的超时时间
     */
    public static final String SERVER_LISTEN = "system.server.listen";
    /**
     * URI Encoding
     */
    public static final String URI_ENCODING = "system.boot.tomcat.uriEncoding";
    /**
     * 处理请求的最小线程数，默认10
     */
    public static final String TOMCAT_MIN_PROCESSTHREAD_COUNT = "system.boot.tomcat.minThread";
    /**
     * 处理请求的最大线程数，默认200
     */
    public static final String TOMCAT_MAX_PROCESSTHREAD_COUNT = "system.boot.tomcat.maxThread";
    /**
     * 最大等待处理的请求数，超过就拒绝了。默认100
     */
    public static final String TOMCAT_MAX_WAIT_COUNT = "system.boot.tomcat.maxWaitCount";

    /**
     * 嵌入式服务绑定的全局上下文路径
     */
    public static final String SERVER_CONTEXTPATH = "system.server.contextPath";

    /**
     * 启动前准备阶段的处理器
     */
    public static final String BOOT_PRE_HANDLER = "system.boot.preHandler";


    /**
     * 当前系统运行模式，一般两个值 dev 或者 product，值是自己配置的
     * 默认是 dev
     */
    public static final String RUN_MODE = "system.run.mode";

    /**
     * 是否开启热加载，需要配合jrebel使用，让开发无比丝滑
     */
    public static final String RUN_HOTDEPLOY = "system.run.hotdeploy";

    /**
     * 是否开启监控
     */
    public static final String MONITOR_ENABLE = "system.run.monitor.enable";

    /**
     * 请求是否支持跨域
     */
    public static final String REQUEST_CORS = "system.run.request.cors";
    /**
     * 用于获取session实例的类
     */
    public static final String REQUEST_SESSION_MANAGER = "system.run.request.session.manager";


    /**
     * 只有匹配这些规则的请求，才会被框架处理，否则交由Servlet容器处理，语法同Filter的url-pattern语法
     */
    public static final String REQUEST_RESOURCES_INCLUDE = "system.run.request.resources.include";

    /**
     * 在include的基础上，匹配这些规则的请求，将跳过拦截器处理，直接请求。语法同Filter的url-pattern语法
     */
    public static final String REQUEST_RESOURCES_EXCLUDE = "system.run.request.resources.exclude";

    /**
     * freemarker配置项
     */
    public static final String FREEMARKER_CONFIG = "system.run.template.freemarker.config";



    /**
     * 上传保存路径
     */
    public static final String UPLOAD_SAVEPATH = "system.run.request.upload.savePath";
    /**
     * 上传单次请求的最大大小
     */
    public static final String UPLOAD_TOTALMAXSIZE = "system.run.request.upload.totalMaxSize";
    /**
     * 上传单个文件的最大大小
     */
    public static final String UPLOAD_SINGLEMAXSIZE = "system.run.request.upload.singleMaxSize";

    /**
     * 不允许上传的文件类型
     */
    public static final String UPLOAD_NOTALLOWSUFFIX =  "system.run.request.upload.notAllowSuffix";

    /**
     * 发生错误比如500,404时，显示的页面
     */
    public static final String SERVER_ERRORPAGES = "system.server.errorPages";
    /**
     * 发生错误比如500,404时，显示的页面
     */
    public static final String SERVER_ERRORPAGE_500 = "system.server.errorPages.500";
    /**
     * 发生错误比如500,404时，显示的页面
     */
    public static final String SERVER_ERRORPAGE_404 = "system.server.errorPages.404";



    /**
     * 自动开启事务的方法名前缀
     */
    public static final String TRANSACTION_PREFIX = "system.run.db.transaction.autoOpenPrefix";

    /**
     * 默认的事务等级
     */
    public static final String DB_TRANSACTION_DEFAULTLEVEL = "system.run.db.transaction.defaultLevel";
    /**
     * 事务执行超时警告，一旦一个事务执行时间超过设定的毫秒值，就打印警告语句
     */
    public static final String DB_TRANSACTION_TIMEOUT_WARNING = "system.run.db.transaction.timeoutWarning";


    /**
     * 默认使用的日志记录器
     */
    public static final String LOGGER_DEFAULT = "system.run.logger.default";

    /**
     * 配置参考log4j官网，链接 <a href="http://logging.apache.org/log4j/2.x/manual/configuration.html#JSON">点击这里</a>
     */
    public static final String LOGGER_CONFIGURATION = "system.run.logger.configuration";

}
