package tech.yixiyun.framework.kuafu.controller;


import tech.yixiyun.framework.kuafu.controller.action.ActionContext;
import tech.yixiyun.framework.kuafu.controller.annotation.Controller;
import tech.yixiyun.framework.kuafu.controller.request.KuafuRequest;
import tech.yixiyun.framework.kuafu.controller.response.KuafuResponse;
import tech.yixiyun.framework.kuafu.view.View;
import tech.yixiyun.framework.kuafu.kits.Kv;
import tech.yixiyun.framework.kuafu.service.Result;

import javax.servlet.http.HttpSession;
import java.io.File;
import java.io.InputStream;

@Controller("(a)(!Controller)")
public abstract class BaseController {

    protected KuafuRequest getRequest() {
        return ActionContext.getRequest();
    }

    protected KuafuResponse getResponse() {
        return ActionContext.getResponse();
    }


    protected HttpSession getSession() {
        return getRequest().getSession();
    }

    /**
     * 调用request的setAttribute方法绑定数据
     * @param key
     * @param value
     */
    protected void setAttr(String key, Object value) {
        getRequest().setAttribute(key, value);
    }

    /**
     * 跳转到某个jsp页面
     * @param path
     * @return
     */
    public View jsp(String path) {
       return View.jspView(path);
    }
    /**
     * 跳转到某个ftl页面
     * @param path
     * @return
     */
    public View ftl(String path) {
       return View.ftlView(path);
    }

    /**
     * 转向到某个地址
     * @param path
     * @return
     */
    public View forward(String path) {
        return View.dispatch(path);
    }

    /**
     * 重定向到某个地址
     * @param path
     * @return
     */
    public View redirect(String path) {
        return View.redirect(path);
    }


    /**
     * 返回一个输出普通字符串的view
     * @param content
     * @return
     */
    public View text(String content) {
        return View.text(content);
    }

    /**
     * 将对象转成json格式字符串返回
     * @param data
     * @return
     */
    public View json(Object data) {
        return View.json(data);
    }

    /**
     * 根据key和value 构造一个json格式对象，然后转成json格式字符串返回
     * @param keyAndValues
     * @return
     */
    public View jsonKV(Object... keyAndValues) {
        return View.json(Kv.of(keyAndValues));
    }


    /**
     * 将result转成json格式字符串返回
     * @param result
     * @return
     */
    public View jsonResult(Result result) {
        return View.jsonResult(result);
    }

    /**
     * 返回一个代表请求成功的json格式字符串，内容是{state:"success"}
     * @return
     */
    public View jsonSuccess() {
        return View.jsonSuccess();
    }
    /**
     * 返回一个代表请求成功的json格式字符串，内容是{state:"success", data: xxxx}
     * @return
     */
    public View jsonSuccess(Object data) {
        return View.jsonSuccess(data);
    }
    /**
     * 返回一个代表请求成功的json格式字符串，内容是{state:"success", data: xxxx, msg:"xxx"}
     * @return
     */
    public View jsonSuccess(Object data, String msg) {
        return View.jsonSuccess(data, msg);
    }

    /**
     * 返回一个代表请求失败的json格式字符串，内容是{state:"fail", msg:"xxxx"}
     * @return
     */
    public View jsonFail(String msg) {
        return View.jsonFail(msg);
    }
    /**
     * 返回一个代表请求失败的json格式字符串，内容是{state:"fail", msg:"xxxx", data: xxx}
     * @return
     */
    public View jsonFail(Object data, String msg) {
        return View.jsonFail(data, msg);
    }

    /**
     * 返回一个代表请求警告的json格式字符串，内容是{state:"warn", msg:"xxx"}
     * @return
     */
    public View jsonWarn(String msg) {
        return View.jsonWarn(msg);
    }
    /**
     * 返回一个代表请求警告的json格式字符串，内容是{state:"warn", msg:"xxx", data: xxx}
     * @return
     */
    public View jsonWarn(Object data, String msg) {
        return View.jsonWarn(data, msg);
    }


    /**
     * 输出一个下载文件流
     * @param fileName
     * @param bytes
     * @return
     */
    public  View download(String fileName, byte[] bytes) {
        return View.download(fileName, bytes);
    }
    /**
     * 输出一个下载文件流
     * @param fileName
     * @param is
     * @return
     */
    public  View download(String fileName, InputStream is) {
        return View.download(fileName, is);
    }
    /**
     * 输出一个下载文件流
     * @param fileName
     * @param file
     * @return
     */
    public  View download(String fileName, File file) {
        return View.download(fileName, file);
    }
    /**
     * 输出一个下载文件流
     * @param fileName
     * @param path 路径，如果已/开头，就以绝对路径解析，否则就以相对项目webapp文件夹的路径去解析
     * @return
     */
    public  View download(String fileName, String path) {
        return View.download(fileName, path);
    }

    /**
     * 输出一个图片流
     * @param is
     * @return
     */
    public View image(InputStream is) {
        return View.image(is);

    }

    /**
     * 输出一个图片流
     * @param bytes
     * @return
     */
    public View image(byte[] bytes) {
        return View.image(bytes);
    }




}
