package tech.yixiyun.framework.kuafu.controller.action;


import tech.yixiyun.framework.kuafu.log.LOGGER;

import java.util.concurrent.ConcurrentLinkedQueue;

/**
 * 一次请求结束时的钩子，可以通过它注册
 */
public class ActionDoneRegistry {

    private static final ThreadLocal<ConcurrentLinkedQueue<IActionDoneHook>> hooks = new ThreadLocal<>();


    /**
     * 请求结束时要干的事
     * @param doWhat
     */
    public static void register(IActionDoneHook doWhat) {
        ConcurrentLinkedQueue<IActionDoneHook> queue = hooks.get();
        if (queue == null) {
            queue = new ConcurrentLinkedQueue<>();
            hooks.set(queue);
        }
        queue.add(doWhat);
    }





    /**
     * 调用所有注册的钩子，这个方法会由框架在请求结束时调用，请不要私自调用。
     */
    public static void execute() {
        ConcurrentLinkedQueue<IActionDoneHook> queue = hooks.get();
        if (queue == null) return;
        while (queue.isEmpty() == false) {
            try {
                queue.poll().execute();
            } catch (Exception e) {
                LOGGER.error(e);
            }
        }
        //为了实现复用，不重复实例化，所以这里用完了不能从threadlocal remove掉 queue

    }





}
