package tech.yixiyun.framework.kuafu.controller.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 指定上传相关参数，用在Controller的方法上
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
public @interface Upload {

    /**
     * 保存路径，默认使用config中的 system.run.request.upload.savePath的值 <br/>
     * 路径基于webroot路径，例如你配置成 /upload，那么就会定位到webapp/upload文件夹下。
     * <b>注意：</b>路径必须是文件的完整路径，这里支持一些表达式，可对路径进行定制，<br/>
     * <ul>
     *     <li>{date:yyyyMMdd} ，日期表达式，格式是{date:日期格式化模式，和SimpleDataFormat使用的表达式一模一样} </li>
     *     <li>{random:10}，随机字符串表达式，格式是{random:字符串长度}</li>
     *     <li>{session:userId}，session中取值，格式是{session:key}</li>
     *     <li>{uuid}，uuid字符串</li>
     *     <li>{originalName}，上传的文件原名称，包含后缀名哦</li>
     *     <li>{suffix}，上传文件的后缀名，不包含 .</li>
     * </ul>
     * 假设你上传了一个文件，名字为 abc.xls，然后savePath配置成 /upload/{date:yyyyMMdd}/{date:HHmmss}_{random:4}.{suffix}，
     * 那么最终文件在服务器保存的路径，可能是 /upload/20200901/105959_a452.xls
     *
     * @return
     */
    String savePath() default "";

    /**
     * 单次请求的最大大小，单位K，默认默认使用config中的 system.run.request.upload.totalMaxSize的值
     * @return
     */
    long totalMaxSize() default 0;
    /**
     * 单文件的最大大小，单位K，默认默认使用config中的 system.run.request.upload.singleMaxSize的值
     * @return
     */
    long singleMaxSize() default 0;

}
