package tech.yixiyun.framework.kuafu.controller.request.param;

import tech.yixiyun.framework.kuafu.bean.annotation.Priority;
import tech.yixiyun.framework.kuafu.controller.annotation.ContentType;
import tech.yixiyun.framework.kuafu.controller.cookie.CookieKit;
import tech.yixiyun.framework.kuafu.controller.request.KuafuRequest;
import tech.yixiyun.framework.kuafu.controller.session.SessionKit;
import tech.yixiyun.framework.kuafu.kits.StringKit;

import java.util.Map;

@Priority(0)
@ContentType({"application/x-www-form-urlencoded",
        "",
        "multipart/form-data"})
public class CommonRequestParamResolver implements IRequestParamResolver {



    @Override
    public Object resolve(KuafuRequest request, ParamDefinition param) {
        if (param.getUrlParamIndex() > -1 ) { //这个参数是一个url参数
            Map<Integer, String> map = request.getUrlParameterMap();
            if (map.containsKey(param.getUrlParamIndex())) {
                return StringKit.convert(map.get(param.getUrlParamIndex()), param.getParameter().getType());
            }
        }

        //这个参数来自session绑定
        if (StringKit.isNotBlank(param.getSessionAttrName())) {
            return SessionKit.getAttribute(param.getSessionAttrName());
        }

        //如果这个参数来自cookie绑定
        if (StringKit.isNotBlank(param.getCookieAttrName())) {
            String cookie = CookieKit.getCookie(param.getCookieAttrName());
            return parseJSONToObject(cookie, param);
        }


        return ParamUtil.compose(param, request.getCommonParameterMap().get(param.getName()));


    }
}
