package tech.yixiyun.framework.kuafu.controller.request.param;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 请求方法的参数类型
 */
public enum ParamType {

    /**
     * 常见类型，例如基本数据类型，String，时间类型，BigInteger,BigDecimal
     */
    COMMON,

    /**
     * 普通JAVA对象
     */
    POJO,

    /**
     * 数组
     */
    ARRAY,

    /**
     * List类型
     */
    LIST,

    /**
     * Map类型
     */
    MAP;

    private static final Map<Class, Object> COMMON_TYPE = new HashMap<Class, Object>(){
        {
            put(boolean.class, Boolean.FALSE);
            put(byte.class, Integer.valueOf(0));
            put(short.class, Integer.valueOf(0));
            put(char.class, Character.valueOf((char) 0));
            put(float.class, Float.valueOf(0));
            put(int.class, Integer.valueOf(0));
            put(long.class, Long.valueOf(0));
            put(double.class, Double.valueOf(0));
            put(Boolean.class, null);
            put(Byte.class, null);
            put(Short.class, null);
            put(Character.class, null);
            put(Integer.class, null);
            put(Float.class, null);
            put(Double.class, null);
            put(Long.class, null);
            put(String.class, null);
            put(Date.class, null);
            put(java.sql.Date.class, null);
            put(Time.class, null);
            put(BigInteger.class, null);
            put(BigDecimal.class, null);
            put(UploadFile.class, null);
        }
    };



    public static ParamType analyseParamType(Class<?> paramClass) {
        if (COMMON_TYPE.containsKey(paramClass)) {
            return COMMON;
        } else if (paramClass.isArray()) {
            return ARRAY;
        } else if (List.class.isAssignableFrom(paramClass)) {
            return LIST;
        } else if (Map.class.isAssignableFrom(paramClass)) {
            return MAP;
        }
        return POJO;
    }

    /**
     * 获取commonType类型的类的默认值
     * @param clazz
     * @return
     */
    public static Object getDefaultValue(Class clazz) {
        return COMMON_TYPE.get(clazz);

    }

}
