package tech.yixiyun.framework.kuafu.controller.request.param;

import cn.hutool.core.io.FileUtil;

import java.io.File;

/**
 * 封装上传的文件
 */
public class UploadFile {

    /**
     * 上传文件的相对路径，相对webRoot文件夹。
     */
    private String relativePath;

    /**
     * 服务器上的绝对路径
     */
    private String absolutePath;

    /**
     * 上传文件的原始文件名
     */
    private String originalName;

    /**
     * 文件后缀名
     */
    private String suffix;

    /**
     * 文件大小
     */
    private long size;


    public File getFile() {
        return new File(this.absolutePath);
    }

    public byte[] getBytes() {
        return FileUtil.readBytes(getFile());
    }

    /**
     * 保存后的文件名称
     * @return
     */
    public String getSaveName() {
        int i = this.relativePath.lastIndexOf("/");
        return this.relativePath.substring(i + 1);
    }

    public String getRelativePath() {
        return relativePath;
    }

    public void setRelativePath(String relativePath) {
        this.relativePath = relativePath;
    }

    public String getAbsolutePath() {
        return absolutePath;
    }

    public void setAbsolutePath(String absolutePath) {
        this.absolutePath = absolutePath;
    }

    public String getOriginalName() {
        return originalName;
    }

    public void setOriginalName(String originalName) {
        this.originalName = originalName;
    }

    public long getSize() {
        return size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getSuffix() {
        return suffix;
    }
}
