package tech.yixiyun.framework.kuafu.controller.session;

import tech.yixiyun.framework.kuafu.component.Component;

import java.util.Enumeration;

/**
 * 用于获取session实例的接口
 */
@Component
public interface ISessionManager {


    /**
     * 获取当前请求的session的实例
     * @return
     */
    Object getSession();


    /**
     * 返回该session的唯一标识
     * @return
     */
    Object getId();

    /**
     * 设置多久无请求后，该session无效。单位秒。如果设置成小于等于0，代表永久有效
     * @param interval
     */
    void setMaxInactiveInterval(int interval);


    /**
     * 获取该session多久无请求后会无效，单位秒
     * @return
     */
    int getMaxInactiveInterval();

    /**
     * 根据key获取绑定的数据
     * @param name
     * @return
     */
    Object getAttribute(String name);

    /**
     * 获取session中所有key值的迭代器
     * @return
     */
    Enumeration<String> getAttributeNames();

    /**
     * 往session中绑定数据
     * @param name
     * @param value
     */
    void setAttribute(String name, Object value);


    /**
     * 从session中移除某个绑定的数据
     * @param name
     */
    void removeAttribute(String name);

    /**
     * 将session标记为无效，并清空它所有绑定数据
     */
    void invalidate();


}
