package tech.yixiyun.framework.kuafu.controller.session;

import tech.yixiyun.framework.kuafu.controller.action.ActionContext;
import tech.yixiyun.framework.kuafu.controller.request.KuafuRequest;

import javax.servlet.http.HttpSession;
import java.util.Enumeration;

/**
 * 用于获取Servlet容器默认的session实现实例
 * @author Yixiyun
 * @version 1.0
 * @date 2021-05-30 21:54
 */
public class ServletSessionManager implements ISessionManager {
    @Override
    public Object getSession() {
        return getHttpSession();
    }


    private HttpSession getHttpSession() {
        KuafuRequest request = ActionContext.getRequest();
        if (request == null) {
            return  null;
        }
        return request.getSession();
    }

    @Override
    public Object getId() {
        return getHttpSession().getId();
    }

    @Override
    public void setMaxInactiveInterval(int interval) {
        getHttpSession().setMaxInactiveInterval(interval);
    }

    @Override
    public int getMaxInactiveInterval() {
        return getHttpSession().getMaxInactiveInterval();
    }

    @Override
    public Object getAttribute(String name) {
        return getHttpSession().getAttribute(name);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return getHttpSession().getAttributeNames();
    }

    @Override
    public void setAttribute(String name, Object value) {
        getHttpSession().setAttribute(name, value);
    }

    @Override
    public void removeAttribute(String name) {
        getHttpSession().removeAttribute(name);
    }

    @Override
    public void invalidate() {
        getHttpSession().invalidate();
    }
}
