package tech.yixiyun.framework.kuafu.controller.session;

import tech.yixiyun.framework.kuafu.bean.BeanContext;
import tech.yixiyun.framework.kuafu.config.AppConfig;
import tech.yixiyun.framework.kuafu.config.AppConfigException;
import tech.yixiyun.framework.kuafu.config.ConfigKey;

import java.util.Enumeration;

/**
 * session工具类
 * @author Yixiyun
 * @version 1.0
 * @date 2021-05-30 21:00
 */
public class SessionKit {

    private static final ISessionManager MANAGER;
    static {
        try {
            Class clazz = Class.forName(AppConfig.getAsString(ConfigKey.REQUEST_SESSION_MANAGER));
            MANAGER = (ISessionManager) BeanContext.getBean(clazz);
        } catch (ClassNotFoundException e) {
            throw new AppConfigException("配置项："+ ConfigKey.REQUEST_SESSION_MANAGER +"值异常", e);
        }


    }

    /**
     * 获取当前session实例，类型需要自己进行强转
     * @return
     */
    public static Object getSession() {
        return MANAGER.getSession();
    }

    /**
     * 获取session中绑定的数据
     * @param name
     * @return
     */
    public static Object getAttribute(String name) {
        return MANAGER.getAttribute(name);
    }
    /**
     * 往session中绑定数据
     * @param name
     * @param value
     */
    public static void setAttribute(String name, Object value) {
        MANAGER.setAttribute(name, value);
    }

    /**
     * 返回该session的唯一标识
     * @return
     */
    public static Object getId() {
        return MANAGER.getId();
    }
    /**
     * 设置多久无请求后，该session无效。单位秒。如果设置成小于等于0，代表永久有效
     * @param interval
     */
    public static void setMaxInactiveInterval(int interval) {
        MANAGER.setMaxInactiveInterval(interval);
    }
    /**
     * 获取该session多久无请求后会无效，单位秒
     * @return
     */
    public static int getMaxInactiveInterval() {
        return MANAGER.getMaxInactiveInterval();
    }

    /**
     * 获取session中所有key值的迭代器
     * @return
     */
    public static Enumeration<String> getAttributeNames() {
        return MANAGER.getAttributeNames();
    }

    /**
     * 从session中移除某个绑定的数据
     * @param name
     */
    public static void removeAttribute(String name) {
        MANAGER.removeAttribute(name);
    }

    /**
     * 将session标记为无效，并清空它所有绑定数据
     */
    public static void invalidate() {
        MANAGER.invalidate();
    }





}
