package tech.yixiyun.framework.kuafu.db.datasource;


import javax.sql.DataSource;
import java.sql.Connection;
import java.sql.SQLException;


/**
 * 数据源包装类。这里包含几个属性，特别重要。<br/>
 * <b>name</b>：为数据源起的名字，如果系统要使用多数据源，就通过name来调用 <br/>
 * <b>isMain</b>：是否是主数据源，一个系统只能有一个主数据源。当执行Sql语句时，如果未指定数据源，就默认使用主数据源。<br/>
 * <b>dataSource</b>：数据源实例 <br/>
 *
 */
public abstract class DataSourceDefinition {


    /**
     * 数据库类型
     */
    protected DbType dbType;

    /**
     * 数据源
     */
    protected DataSource dataSource;
    /**
     * 为数据源起的名字，如果系统要使用多数据源，就通过name来调用
     */
    protected String name;

    /**
     * 是否是主数据源，一个系统只能有一个主数据源。当执行Sql语句时，如果未指定数据源，就默认使用主数据源。
     */
    protected boolean isMain;

    public DataSourceDefinition(){}


    /**
     * 指定如何关闭数据源连接池
     */
    public abstract void close();

    /**
     *
     * @param name
     * @param dbType
     * @param dataSource
     * @param isMain 是否是主数据库
     */
    public DataSourceDefinition(String name,DbType dbType, DataSource dataSource,boolean isMain) {
        this.name = name;
        this.dbType = dbType;
        this.dataSource = dataSource;
        this.isMain = isMain;
    }


    public Connection getConnection() {
        try {
            return this.dataSource.getConnection();
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public DataSource getDataSource() {
        return dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean getIsMain() {
        return isMain;
    }

    public void setIsMain(boolean main) {
        isMain = main;
    }

    public DbType getDbType() {
        return dbType;
    }

    public void setDbType(DbType dbType) {
        this.dbType = dbType;
    }

}
