package tech.yixiyun.framework.kuafu.db.datasource;

import tech.yixiyun.framework.kuafu.db.DbException;
import tech.yixiyun.framework.kuafu.kits.StringKit;

/**
 * 数据库类型，只有这里提供的类型数据库，才被框架支持
 */
public enum DbType {

    MYSQL;

    ;




    public static DbType getByName(String name) {
        if (StringKit.isBlank(name)) return null;
        try {
            DbType dbType = DbType.valueOf(name.toUpperCase());
            return dbType;
        } catch (Exception e) {
            throw new DbException("暂时不支持" + name + "数据源");
        }
    }



}
