package tech.yixiyun.framework.kuafu.db.sql;

import java.io.Serializable;

/**
 * Sql表达式包装类，拼接Sql语句时，默认会用PreparedStatement，参数最后会通过替换占位符传入，但只能识别为值，不能识别为sql表达式，
 * 比如 update user set name = sn，让name字段值 = sn字段值，如果通过 update user set name = ? 的方式，然后传入一个sn，那就相当于
 * update tbuser set name = "sn" 了，又或者 select * from user where age < schoolyear+7 ，这里的 schoolyear+ 7 是一个表达式，
 * 通过占位符方式传值也不可行，这时候就可以通过 Exp类将上面两个例子中的 sn 或者 schoolyear+7 包装后传给Sql，这样Sql处理的时候就会原样输出，不会用占位符。 <br/><br/>
 * <b>注意：这样无法拦截Sql注入了，通过这个时一定需要自己保证Exp内容的安全性</b>
 */
public class Exp implements Serializable {
    private String value;

    public static Exp new_(String expression) {
        return new Exp(expression);
    }

    public Exp(String expression) {
        this.value = expression;
    }

    public String getValue() {
        return value;
    }

    @Override
    public String toString() {
        return value;
    }
}
