package tech.yixiyun.framework.kuafu.db.sql;

import java.util.List;

/**
 * 封装分页数据的类
 * @param <T>
 */
public class Pager<T> {

    /**
     * 分页数据
     */
    private List<T> list;

    /**
     * 数据总量
     */
    private int totalCount;

    /**
     * 当前第几页
     */
    private int pageNum;

    /**
     * 每页多少条数据
     */
    private int pageSize;


    public Pager() {}




    public Pager(int pageNum, int pageSize) {
        this.pageNum = pageNum;
        this.pageSize = pageSize;
    }

    /**
     * 构建一个新的pager对象
     * @param pageNum
     * @param pageSize
     * @return
     */
    public static Pager build(int pageNum, int pageSize) {
        return new Pager(pageNum, pageSize);
    }



    public List<T> getList() {
        return list;
    }

    public void setList(List<T> list) {
        this.list = list;
    }




    /**
     * 总页数
     * @return
     */
    public int getPageCount() {
        if (pageSize == 0) return 0;

        int count = totalCount / pageSize;

        return totalCount % pageSize == 0 ? count : (count+1);
    }

    public Integer getTotalCount() {
        return totalCount;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    public int getPageNum() {
        return pageNum;
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }
}
