package tech.yixiyun.framework.kuafu.db.sql.handler;

import org.apache.commons.dbutils.ResultSetHandler;

import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * 插入数据后，如果有自增列，根据Field对自增结果做处理
 */
public class IdColumnHandler implements ResultSetHandler {
    private Field idField; //id字段
    private Object instance;
    public IdColumnHandler(Field idField, Object instance) {
        this.idField = idField;
        this.instance = instance;
    }
    @Override
    public Object handle(ResultSet rs) throws SQLException {
        if (idField == null || rs.next() == false) return null;
        Object v = null;
        if (idField.getType() == int.class|| idField.getType() == Integer.class) {
            v= rs.getInt(1);
        } else if (idField.getType() == long.class || idField.getType() == Long.class) {
            v= rs.getLong(1);
        }
        if (v != null) {
            try {
                idField.set(instance, v);
            } catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return v;
    }
}
