package tech.yixiyun.framework.kuafu.db.transaction;

/**
 * 事务等级
 * @author Yixiyun
 * @date 2021-04-24 15:39
 * @version 1.0
 */
public enum TransactionLevel {
    /**
     * 使用连接池或者数据库默认的隔离级别，Druid连接池会强制连接默认使用READ_COMMITTED隔离级别。
     * 但是Mysql数据库默认的隔离级别是REPEATABLE_READ，Mysql的这个级别解决了脏读幻读不可重复读所有问题。
     */
    DEFAULT(-1),

    /**
     * 不需要事务
     */
    NONE(0),

    /**
     * 未提交读事务等级
     */
    READ_UNCOMMITTED(1),

    /**
     * 提交读事务等级
     */
    READ_COMMITTED(2),

    /**
     * 可重复读事务等级，
     */
    REPEATABLE_READ(4),


    /**
     * 序列化事务等级
     */
    SERIALIZABLE(8)

    ;


    private int level;

    private TransactionLevel(int level) {
        this.level = level;
    }


    public int getLevel() {
        return level;
    }


    /**
     * 根据给定的值获取对应的等级
     * @param level
     * @return
     */
    public static TransactionLevel getByValue(Integer level) {
        if (level == null) {
            return null;
        }
        TransactionLevel[] values = TransactionLevel.values();
        for (TransactionLevel value : values) {
            if (value.getLevel() == level) {
                return value;
            }
        }
        return null;
    }




}
