package tech.yixiyun.framework.kuafu.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import tech.yixiyun.framework.kuafu.domain.annotation.Column;
import tech.yixiyun.framework.kuafu.domain.annotation.Domain;

import java.io.Serializable;

@Domain
public abstract class BaseDomain implements Serializable {



    @Column(isTemp = true)
    @JsonIgnore
    protected String[] nullColumns; //将值设置为null的字段

    /**
     * 将某些字段值设置为null。默认情况下，如果一个字段的值是null，插入和更新会忽略该字段，让数据库自动处理。
     * 所以如果你想告诉数据库，这条记录的这个字段值就是要设成null，那么就通过这个方法来实现吧
     * @param columns
     */
    public void setNull(String... columns) {
        this.nullColumns = columns;
    }

    /**
     * 获取将值设置为null的字段
     * @return
     */
    public String[] getNullColumns() {
        return nullColumns;
    }

}
