package tech.yixiyun.framework.kuafu.domain.annotation;


import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;


/**
 * 只能用于Domain类的字段，设置字段对应的数据表的列信息
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
public @interface Column {

    /**
     * 指定字段在数据库中的类型，默认情况，框架会自动判断
     * @return
     */
    ColumnType type() default ColumnType.DEFAULT;

    /**
     * 该Field映射的数据库字段名，默认就是field 名称
     * @return
     */
    String name() default "";


    /**
     * 指定字段的长度，默认情况下，字符串类型255个字符长度，小数类型数值总长度20位，int类型默认11，long类型默认20
     * @return
     */
    int length() default 0;

    /**
     * 如果字段是decimal类型，通过它来指定小数位数，默认保留4位小数，结合length属性使用，decimal默认20位总长度。
     * 框架会默认将Domain类中的Double类型字段，使用numeric来创建表字段。
     * @return
     */
    int precision() default 4;

    /**
     * 字段注释
     * @return
     */
    String comment() default "";

    /**
     * 是否是主键，如果不指定主键，系统会默认找到叫id名字的字段，将它指定为主键，否则不设置主键。
     * 被指定为主键后，可以通过 generateFrom 属性来指定主键值的生成方式。默认值false
     * @return
     */
    boolean isPrimary() default false;

    /**
     * 主键赋值方式，只有在该字段是主键字段时有效。默认是框架自己判断，如果是int类型会使用自增，long类型，string类型都会使用雪花算法生成，其他类型需要自己指定。
     * @return
     */
    GenerateFrom generateFrom() default GenerateFrom.DEFAULT;

    /**
     * 位数不足，是否自动补0，只适合数值类型，默认false
     * @return
     */
    boolean zerofill() default false;

    /**
     * 是否指定字段必须notnull，默认是false
     * @return
     */
    boolean notNull() default false;

    /**
     * 指定字段默认值，当字段未指定notnull时，字段默认是default null
     * @return
     */
    String defaultValue() default "null";

    /**
     * 是否无符号，只适合数字类型字段，默认false
     * @return
     */
    boolean unsigned() default  false;

    /**
     * 标记该字段是否是临时字段，只参与query类型sql结果的封装，但不参与增删改类型sql执行过程，表构建时也忽略该字段。<Br/>
     * 多用于联表查询时，存放其他表数据。
     * @return
     */
    boolean isTemp() default false;

    /**
     * 是否需要对字段内容做xss处理，防止xss攻击。主要是通过XSSKit的process方法处理。该方法会将:<br/>
     * 1. 将&lt;script 的< 替换成全角字符<br/>
     * 2. 将eval() 的 ( 替换成中文<br/>
     * 3. 将javascript: 的 : 替换成中文<br/>
     * 4. 将vbscript: 的 : 替换成中文<br/>
     * 5. 将expression() 的 ( 替换成中文<br/>
     *
     * @return
     */
    boolean xss() default true;

}
