package tech.yixiyun.framework.kuafu.domain.annotation;

/**
 * 数据表列类型
 */
public enum ColumnType {

    /**
     * 默认类型，表示让程序自己根据java Field类型判断，该用哪个
     */
    DEFAULT,

    /**
     * 二进制数组
     */
    BLOB,

    /**
     * 可变字符串，可以通过 @Column 注解的length属性，指定长度，否则使用默认长度，一般255个字符长度
     */
    VARCHAR,

    /**
     * 固定字符串，可以通过 @Column 注解的length属性，指定长度，否则使用默认长度，一般255个字符长度
     */
    CHAR,

    /**
     * 长文本类型，最多存储 64KB的文本
     */
    TEXT,

    /**
     * 大文本类型，最多存储 16M 大小的文本
     */
    MEDIUMTEXT,

    /**
     * 1位整数，只能表示0、1，对应java的 boolean 类型
     */
    BIT,
    /**
     * 微小整数，最多表示256个数字，对应java的 byte类型
     */
    TINYINT,

    /**
     * 小整数，最多表示65535个数字，对应java的 short类型
     */
    SMALLINT,

    /**
     * 32位整数，对应java的 int类型
     */
    INT,

    /**
     * 64位整数，对应java的long类型
     */
    BIGINT,

    /**
     * 单精度小数，对应java的float类型
     */
    FLOAT,

    /**
     * 双精度小数，对应java的double类型
     */


    /**
     * 小数，需要通过 @Column 注解的 length 属性指定数值总位数，通过 precision 属性指定精度。
     * 对应java的 BigDecimal类型 和 Double类型，是的你没看错，Double类型，默认用Decimal实现
     */
    DECIMAL,

    /**
     * 日期，只保存到年月日，
     */
    DATE,

    /**
     * 日期，保存到时分秒，对应java的 Date类型
     */
    DATETIME,

    /**
     * 时分秒，对应java的 Time类型
     */
    TIME,

    /**
     * 时间戳
     */
    TIMESTAMP,

    /**
     * JSON格式
     */
    JSON,



}
