package tech.yixiyun.framework.kuafu.domain.annotation;

import java.lang.annotation.*;

/**
 * 将类标记为Domain类。
 * 如果通过该注解指定了tableName，并且tableName中包含*，那么就认为是分表，每个*都代表一个变量，通过传参生成完整表名。
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@Inherited
public @interface Domain {

    /**
     * 对应哪个数据来源中的表，不指定的话，就是默认数据来源
     * @return
     */
    String dataSource() default "";

    /**
     * 对应的是数据库的表还是视图，如果是视图，那么构造表结构时会跳过该Domain类。默认是表
     * @return
     */
    DomainType type() default DomainType.TABLE;
    /**
     * 指定该Domain类映射的表名，默认就是类名
     * @return
     */
    String tableName() default "";

    /**
     * 表使用的引擎，默认innodb引擎
     * @return
     */
    String engine() default "innodb";
    /**
     * 表使用的默认字符集
     * @return
     */
    String charset() default "utf8mb4";

    /**
     * 表注释
     * @return
     */
    String comment() default "";

//    /**
//     * 是否是分表，分表就是将数据根据一定的条件拆分到不同表里。比如因为用户数据量太大，以及不同公司的用户数据在一个表里不安全，
//     * 通过分表，可以为每个公司创建一个独立的用户表，这个是物理实现的，每个表都独立，互不影响，但这些表都和这个Domain类映射。<br/>
//     * 如果设置了分表，必须同时设置分表命名规则
//     * @return
//     */
//    boolean isSplit() default false;
//
//    /**
//     * 分表命名规则，用于结合变量生成表名。比如有一个Domain类，类名是User，通过@Domain注解，我们设置了
//     * 它的splitRule值为 user_*_* ，这时候我们要为某个公司某个部门生成专属的user表，通过 DbUtil.getTableName(User.class, 1, 1)
//     * 就可以为公司id是1，部门id是1的单位生成它对应的表名：user_1_1了
//     * @return
//     */
//    String splitRule() default "";

    /**
     * 索引
     * @return
     */
    Key[] keys() default {};
}
