package tech.yixiyun.framework.kuafu.domain.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Target;

/**
 * 表索引注解
 */
@Target(ElementType.TYPE_USE)
public @interface Key {

    /**
     * 索引类型，默认普通索引
     * @return
     */
    KeyType type() default KeyType.NORMAL;

    /**
     * 索引名称
     * @return
     */
    String name() ; //索引名称

    /**
     * 生成索引的列
     * @return
     */
    String[] columns(); //生成索引的列名

}
