package tech.yixiyun.framework.kuafu.enhance;


import net.bytebuddy.implementation.bind.annotation.*;
import tech.yixiyun.framework.kuafu.bean.BeanContext;
import tech.yixiyun.framework.kuafu.bean.BeanDefinition;
import tech.yixiyun.framework.kuafu.enhance.hancer.IEnhancer;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/**
 * 类拦截器，生成代理类时用，被代理类的方法执行时，都会先被拦截器处理
 */
public class ClassInterceptor {

    public static final ClassInterceptor INSTANCE = new ClassInterceptor();
    private ClassInterceptor() {}

    @RuntimeType
    public Object intercept(@AllArguments Object[] args, @SuperMethod Method method
            , @Origin Method oriMethod
            , @This Object obj
    ) {
        BeanDefinition beanDefinition = BeanContext.getBeanDefinition(oriMethod.getDeclaringClass());
        IEnhancer[] enhancers = beanDefinition == null ? null : beanDefinition.getEnhances();

        callEnhancersBeforeDo(enhancers, obj, oriMethod, args);

        Object result = null;
        try {
            result = method.invoke(obj, args);
            callEnhancersAfterDo(enhancers, obj, oriMethod, args, result);
        } catch (InvocationTargetException e) {
            callEnhancersAfterExceptionDo(enhancers, obj, oriMethod, args, e.getTargetException());
        } catch (Exception e) {
            callEnhancersAfterExceptionDo(enhancers, obj, oriMethod, args, e.getCause()==null ? e : e.getCause());
        } finally {
            callEnhancersFinishDo(enhancers, obj, oriMethod, args);
        }

        return result;
    }

    private void callEnhancersFinishDo(IEnhancer[] enhancers, @This Object obj, @Origin Method oriMethod, @AllArguments Object[] args) {
        if (enhancers != null) {
            for (int i = enhancers.length-1; i >= 0; i--) {
                IEnhancer enhancer = enhancers[i];
                enhancer.finishDo(obj, oriMethod, args);
            }
        }
    }

    private void callEnhancersAfterExceptionDo(IEnhancer[] enhancers, @This Object obj, @Origin Method oriMethod, @AllArguments Object[] args, Throwable e) {
        if (enhancers != null) {
            for (int i = enhancers.length-1; i >= 0; i--) {
                IEnhancer enhancer = enhancers[i];
                enhancer.afterExceptionDo(obj, oriMethod, args, e);
            }
        } else {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private void callEnhancersAfterDo(IEnhancer[] enhancers, @This Object obj, @Origin Method oriMethod, @AllArguments Object[] args, Object result) {
        if (enhancers != null) {
            for (int i = enhancers.length - 1; i >= 0; i--) {
                IEnhancer enhancer = enhancers[i];
                enhancer.afterDo(obj, oriMethod, args, result);
            }
        }
    }

    private void callEnhancersBeforeDo(IEnhancer[] enhancers, @This Object obj, @Origin Method oriMethod, @AllArguments Object[] args) {
        if (enhancers != null) {
            for (IEnhancer enhancer : enhancers) {
                enhancer.beforeDo(obj, oriMethod, args);
            }
        }
    }


}
