package tech.yixiyun.framework.kuafu.enhance;

import tech.yixiyun.framework.kuafu.enhance.annotation.Enhance;
import tech.yixiyun.framework.kuafu.enhance.hancer.IEnhancer;
import tech.yixiyun.framework.kuafu.kits.ObjectKit;

import java.lang.annotation.Annotation;
import java.util.HashSet;

/**
 * 类加强也就是AOP工具类
 *
 * @author Yixiyun
 * @version 1.0
 * @date 2021-05-15 14:42
 */
public class EnhanceKit {


    /**
     * 递归一个类的所有父类，查找声明的所有Enhancer注解
     * @param clazz
     * @return
     */
    public static Class<? extends IEnhancer>[] getEnhanceClasses(Class clazz) {
        HashSet<Class<? extends IEnhancer>> set = null;
        Annotation[] annotations = null;
        while (clazz != Object.class) {
            annotations = clazz.getDeclaredAnnotationsByType(Enhance.class);
            if (annotations.length !=0) {
                if (set == null) set = new HashSet<>();
                for (Annotation annotation : annotations) {
                    for (Class<? extends IEnhancer> enhancer : ((Enhance)annotation).value()) {
                        set.add(enhancer);
                    }
                }
            }
            clazz = clazz.getSuperclass();

        }


        return ObjectKit.ifNotNull(set, s -> s.toArray(Class[]::new));
    }

}



