package tech.yixiyun.framework.kuafu.kits;


import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;

import java.util.Date;

public class DateKit extends DateUtil {

    public static final String DATE_YMDHMS = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_YMDHM = "yyyy-MM-dd HH:mm";
    public static final String DATE_YMD = "yyyy-MM-dd";
    public static final String DATE_MDHM = "MM-dd HH:mm";
    public static final String DATE_MDHMS = "MM-dd HH:mm:ss";
    public static final String DATE_HMS = "HH:mm:ss";
    public static final String DATE_MD = "MM-dd";
    public static final String DATE_HM = "HH:mm";


    /**
     * 字符串转Date，支持以下格式的转换：<br/>
     * 时间戳 <br/>
     * yyyy-MM-dd HH:mm:ss<br/>
     * yyyy-MM-dd<br/>
     * MM-dd<br/>
     * HH:mm:ss<br/>
     * HH:mm<br/>
     *
     * @param date
     * @return
     */
    public static Date parseDate(String date) {
        if (StringKit.isBlank(date)) {
            return null;
        }
        date = date.replace("T", " ");
        switch (date.length()) {
            case 24: //2021-03-31 14:51:37.393Z
                date = date.substring(0, 19);
            case 19: //2020-09-09 11:00:00
                return DateKit.parseToDate(date, DATE_YMDHMS);
            case 16: //2020-09-09 11:00
                return DateKit.parseToDate(date, DATE_YMDHM);
            case 14: //09-09 10:10:10
                return DateKit.parseToDate(date, DATE_MDHMS);
            case 13: //时间戳
                return new Date(Long.valueOf(date));
            case 11: //09-09 10:10
                return DateKit.parseToDate(date, DATE_MDHM);
            case 10: //2020-09-09
                return DateKit.parseToDate(date, DATE_YMD);
            case 8: //00:00:00
                return DateKit.parseToDate(date, DATE_HMS);
            case 5: //01-01或者 00：00
                if (date.indexOf("-")>0) {
                    return DateKit.parseToDate(date, DATE_MD);
                } else if (date.indexOf(":") > 0) {
                    return DateKit.parseToDate(date, DATE_HM);
                }

            default:
                throw new RuntimeException("无法识别"+date+"，无法转换为Date类型");
        }
    }


    /**
     * 将特定格式的日期转换为Date对象
     *
     * @param dateStr 特定格式的日期
     * @param format  格式，例如yyyy-MM-dd
     * @return 日期对象
     */
    public static Date parseToDate(CharSequence dateStr, String format) {
        return new DateTime(dateStr, format).toJdkDate();
    }

}
