package tech.yixiyun.framework.kuafu.kits;

import cn.hutool.core.io.FileUtil;

/**
 * 文件工具类
 */
public class FileKit extends FileUtil {
    /**
     * 图片后缀名
     */
    public static final String[] IMG_SUFFIXS= new String[]{".png", ".bmp", ".jpg", ".jpeg"};
    /**
     * 视频后缀名
     */
    public static final String[] VIDEO_SUFFIXS= new String[]{".mp4", ".avi", ".flv"};


    /**
     * 根据文件名判断是否是图片格式
     * @param fileName
     * @return
     */
    public static boolean isImg(String fileName) {
        if (StringKit.isBlank(fileName)) {
            return false;
        }
        fileName = fileName.toLowerCase();
        for (int i = 0; i < IMG_SUFFIXS.length; i++) {
            if (fileName.endsWith(IMG_SUFFIXS[i])) {
                return true;
            }
        }

        return false;
    }
    /**
     * 根据文件名判断是否是图片格式
     * @param fileName
     * @return
     */
    public static boolean isVideo(String fileName) {
        if (StringKit.isBlank(fileName)) {
            return false;
        }
        fileName = fileName.toLowerCase();
        for (int i = 0; i < VIDEO_SUFFIXS.length; i++) {
            if (fileName.endsWith(VIDEO_SUFFIXS[i])) {
                return true;
            }
        }

        return false;
    }


}
