package tech.yixiyun.framework.kuafu.kits;

import cn.hutool.http.HttpUtil;

import javax.servlet.http.HttpServletRequest;

public class HttpKit extends HttpUtil {


    private static final String UNKONWN = "unknown";

    private static final String HEADER = "X-Forwarded-For";

    private static final String WEBLOGIC = "WL-Proxy-Client-IP";
    private static final String NGINX = "X-Real-IP";

    public static String getIPAddress(HttpServletRequest request) {
        String ip = null;

        //X-Forwarded-For：Squid 服务代理
        String ipAddresses = request.getHeader(HEADER);


        if (ipAddresses == null || ipAddresses.length() == 0 || UNKONWN.equalsIgnoreCase(ipAddresses)) {
            //WL-Proxy-Client-IP：weblogic 服务代理
            ipAddresses = request.getHeader(WEBLOGIC);
        }

        if (ipAddresses == null || ipAddresses.length() == 0 || UNKONWN.equalsIgnoreCase(ipAddresses)) {
            //X-Real-IP：nginx服务代理
            ipAddresses = request.getHeader(NGINX);
        }

        //有些网络通过多层代理，那么获取到的ip就会有多个，一般都是通过逗号（,）分割开来，并且第一个ip为客户端的真实IP
        if (ipAddresses != null && ipAddresses.length() != 0) {
            ip = ipAddresses.split(",")[0];
        }

        //还是不能获取到，最后再通过request.getRemoteAddr();获取
        if (ip == null || ip.length() == 0 || UNKONWN.equalsIgnoreCase(ipAddresses)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

}
