package tech.yixiyun.framework.kuafu.kits;

import cn.hutool.core.util.ObjectUtil;

import java.util.function.Function;

/**
 * 对象工具类
 */
public class ObjectKit extends ObjectUtil {

    /**
     * 传入一个原始对象进来，如果对象为null，就返回null，不是null，就执行function函数式获取结果
     * @param source
     * @param function
     * @param <T>
     * @param <R>
     * @return
     */
    public static <T, R> R ifNotNull(T source, Function<T, R> function) {
        if (source == null) {
            return null;
        }
        return function.apply(source);
    }


}
