package tech.yixiyun.framework.kuafu.kits;

import cn.hutool.crypto.digest.DigestUtil;

import java.util.Objects;

/**
 * 密码工具
 */
public class PwdKit {


    public static void main(String[] args) {
        System.out.println(calByMd5("Zhangyi0323", "123"));
    }

    /**
     * 计算md5值
     * @param str
     * @return
     */
    public static String calByMd5(String str) {
        if (StringKit.isBlank(str)) {
            throw new RuntimeException("字符串为空，无法生成密码");
        }
        return DigestUtil.md5Hex(str);
    }

    /**
     * 根据md5生成规则，判断传入的原始密码加密后和指定结果是否一致
     * @param pwd
     * @param encryptedPwd
     * @return
     */
    public static boolean checkIsSame(String pwd, String encryptedPwd) {
        if (StringKit.isBlank(pwd)) {
            return false;
        }
        return Objects.equals(calByMd5(pwd), encryptedPwd);

    }

    /**
     * 盐值加密，src加密后的字符串拼接salt后再次加密
     * @param str
     * @param salt
     * @return
     */
    public static String calByMd5(String str, String salt) {
        if (StringKit.isBlank(salt)) {
            throw new RuntimeException("盐值为空，无法生成密码");
        }
        String oriPwd = calByMd5(str);
        return calByMd5(oriPwd + salt);
    }

    /**
     * 根据盐值加密生成规则，判断传入的密码加密后和指定结果是否一致
     * @param pwd
     * @param salt
     * @param encryptedPwd
     * @return
     */
    public static boolean checkIsSame(String pwd, String salt, String encryptedPwd) {
        if (StringKit.isBlank(pwd)) {
            return false;
        }
        return Objects.equals(calByMd5(pwd, salt), encryptedPwd);

    }





}
