package tech.yixiyun.framework.kuafu.kits;

import tech.yixiyun.framework.kuafu.log.LOGGER;
import tech.yixiyun.framework.kuafu.shutdown.ShutdownRegistry;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * 任务工具类，通过一个线程池执行指定的任务
 */
public class TaskKit {

    private static final ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors()/2);

    static {
        ShutdownRegistry.register(() -> {
            executor.shutdown();
        });
    }

    /**
     * 执行任务
     * @param task
     */
    public static <T,R> void execute(Runnable task) {
        executor.execute(task);
    }


    /**
     * 关闭线程池
     */
    public static void shutdown() {
        LOGGER.info("任务线程池准备关闭");
        executor.shutdown();
    }



}
