package tech.yixiyun.framework.kuafu.kits;

import java.util.ArrayList;
import java.util.List;

/**
 * 阻止xss攻击的工具类
 */
public class XSSKit {

    public static final List<String[]> RULES = new ArrayList<>();
    static  {
        RULES.add(new String[]{"<\\s*script", "＜script"});
        RULES.add(new String[]{"eval\\s*\\(", "eval（"});
        RULES.add(new String[]{"expression\\s*\\(", "expression（"});
        RULES.add(new String[]{"javascript:", "javascript："});
        RULES.add(new String[]{"vbscript:", "vbscript："});
    }

    /**
     * 处理原字符串
     * @param src
     * @return
     */
    public static String process(String src) {
        if (StringKit.isBlank(src)) return src;
        for (String[] rule : RULES) {
            src = src.replaceAll(rule[0], rule[1]);
        }
        return src;


    }


}
