package tech.yixiyun.framework.kuafu.kits.wx.wxapp;

import tech.yixiyun.framework.kuafu.kits.HttpKit;
import tech.yixiyun.framework.kuafu.kits.JSONKit;
import tech.yixiyun.framework.kuafu.kits.Kv;

/**
 * 微信小程序工具类
 */
public class WxappKit {

    /**
     * 根据小程序登录接口获得的code，进行登录凭证校验.<a href="https://developers.weixin.qq.com/miniprogram/dev/api-backend/open-api/login/auth.code2Session.html">参考文档</a><br/>
     * 返回json格式数据：<br/>
     * openid：用户唯一标识 <br/>
     * session_key： 会话密钥<br/>
     * unionid：用户在开放平台的唯一标识符<br/>
     * errcode：错误码，一旦发生错误，就会有这个字段<br/>
     * errmsg：	错误信息<br/>
     * @param appId 小程序appid
     * @param appsecret 小程序appsecret
     * @param code
     * @return
     */
    public static WxAppAuth checkCode(String appId, String appsecret, String code) {
        String result = HttpKit.get("https://api.weixin.qq.com/sns/jscode2session",
                Kv.of("appid", appId, "secret", appsecret, "js_code", code, "grant_type", "authorization_code"));
        return JSONKit.toObject(result, WxAppAuth.class);
    }


    public static void main(String[] args) {
        WxAppAuth map = checkCode("wxd85ff53de978d50d", "7bc01e922b4a327167f0adea41fd0950", "031Vd9000uPm7L1b83200ihk9v1Vd90C");
        System.out.println(map.getErrcode());
    }

}
