package tech.yixiyun.framework.kuafu.log;


import org.apache.juli.logging.Log;

/**
 * 日志实例，实现了LOG接口，通过ServiceLoader机制，会被tomcat的LogFactory加载，替换默认的日志实现。
 * @author Boolone
 * @date 2019/12/15
 */
public class TomcatLogger implements Log {



    public TomcatLogger() {
    }

    public TomcatLogger(String name) {
    }



    @Override
    public boolean isDebugEnabled() {
        return false;
    }

    @Override
    public boolean isErrorEnabled() {
        return true;
    }

    @Override
    public boolean isFatalEnabled() {
        return true;
    }

    @Override
    public boolean isInfoEnabled() {
        return true;
    }

    @Override
    public boolean isTraceEnabled() {
        return false;
    }

    @Override
    public boolean isWarnEnabled() {
        return true;
    }

    @Override
    public void trace(Object message) {
    }

    @Override
    public void trace(Object message, Throwable t) {
    }

    @Override
    public void debug(Object message) {
    }

    @Override
    public void debug(Object message, Throwable t) {
    }

    @Override
    public void info(Object message) {
        LOGGER.info(message);
    }

    @Override
    public void info(Object message, Throwable t) {
        LOGGER.info(message, t);
    }

    @Override
    public void warn(Object message) {
        LOGGER.warn(message);
    }

    @Override
    public void warn(Object message, Throwable t) {
        LOGGER.warn(message, t);
    }

    @Override
    public void error(Object message) {
        LOGGER.error(message);
    }

    @Override
    public void error(Object message, Throwable t) {
        LOGGER.error(message, t);
    }

    @Override
    public void fatal(Object message) {
        LOGGER.fatal(message);
    }

    @Override
    public void fatal(Object message, Throwable t) {
        LOGGER.fatal(message, t);
    }



}
