package tech.yixiyun.framework.kuafu.plugins.hotdeploy;

import java.util.Timer;
import java.util.TimerTask;

/**
 * 文件变动记录
 *
 * @author Yixiyun
 * @version 1.0
 * @date 2021-05-14 22:41
 */
public class ChangeLog {

    /**
     * 变动的是否是一个类文件
     */
    private boolean isClass;

    /**
     * 变动的文件路径，如果是普通文件，那就是文件的绝对路径，如果是类，那就是类的完全路径
     */
    private String path;

    /**
     * 变动类型
     */
    private Change changeType;

    /**
     * 定时器
     */
    private Timer timer ;

    public ChangeLog(boolean isClass, String path, Change changeType) {
        this.isClass = isClass;
        this.path = path;
        this.changeType = changeType;

        this.timer = new Timer();
        final ChangeLog that = this;
        timer.schedule(new TimerTask() {
            @Override
            public void run() {
                HotDeployListener.removeChangeLog(that.path);

                HotDeployHandler.handle(that);

            }
        }, 1200);


    }
    public void stopTimer() {
        this.timer.cancel();
    }



    public Timer getTimer() {
        return timer;
    }

    public boolean isClass() {
        return isClass;
    }

    public void setClass(boolean aClass) {
        isClass = aClass;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Change getChangeType() {
        return changeType;
    }

    public void setChangeType(Change changeType) {
        this.changeType = changeType;
    }


}
