package tech.yixiyun.framework.kuafu.service;


import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * 业务处理结果，如果state是ERROR，会触发事务回滚
 */
public class Result<T> {

    /**
     * 业务结束状态，如果是ERROR，会触发事务回滚
     */
    protected State state;

    /**
     * 业务处理后的提示信息
     */
    protected String msg;

    /**
     * 业务处理后的数据
     */
    protected T data;

    public Result(){}

    public Result(State state) {
        this.state = state;
    }



    public Result(State state, String msg) {
        this.state = state;
        this.msg = msg;
    }


    public Result(State state, T data) {
        this.state = state;
        this.data = data;
    }


    public Result(State state, T data, String msg) {
        this.state = state;
        this.data = data;
        this.msg = msg;
    }

    /**
     * 是否执行成功
     * @return
     */
    @JsonIgnore
    public boolean isSuccess() {
        return this.state == State.SUCCESS;
    }

    /**
     * 是否发生错误
     * @return
     */
    @JsonIgnore
    public boolean isError() {
        return this.state == State.FAIL;
    }

    /**
     * 是否发生警告
     * @return
     */
    @JsonIgnore
    public boolean isWarn() {
        return this.state == State.WARN;
    }



    public State getState() {
        return state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }
}
