package tech.yixiyun.framework.kuafu.service.annotation;


import tech.yixiyun.framework.kuafu.component.Component;

import java.lang.annotation.*;


/**
 * 通过该注解将一个类标记为一个Service类。Service类默认就是一个Bean，不需要额外使用@Bean注解了。并且是单例模式哦。<br/>
 * 该注解是可继承的，所以强烈推荐和Controller一样，在一个父类上使用该注解，然后让其他Service类来继承这个父类。<br/>
 * <b>更强烈推荐的是，</b>一定要继承使用我们提供的BaseService这个父类，它无比强大，继承它之后，你就可以使用很多非常方便的方法
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Inherited
@Component
public @interface Service {
}
