package tech.yixiyun.framework.kuafu.shutdown;


import java.util.concurrent.ConcurrentLinkedQueue;

/**
 * 服务器关闭时的钩子，可以通过它注册
 */
public class ShutdownRegistry {

    private static final ConcurrentLinkedQueue<IShutdownHook> hooks = new ConcurrentLinkedQueue<>();


    /**
     * 注册容器关闭时要干的事
     * @param doWhat
     */
    public static void register(IShutdownHook doWhat) {
        hooks.add(doWhat);
    }

    /**
     * 调用所有注册的钩子，这个方法会由框架在容器停止时调用，请不要私自调用。
     */
    public static void execute() {
        while (hooks.isEmpty() == false) {
            hooks.poll().execute();
        }
    }





}
