package tech.yixiyun.framework.kuafu.view;

import tech.yixiyun.framework.kuafu.kits.JSONKit;

import java.io.IOException;

/**
 * 响应返回json格式字符串
 * @author Boolone
 * @date 2020/1/12
 */
public class JSONView extends View {

    /**
     * 表示成功
     */
    public static final String STATE_SUCCESS = "success";

    /**
     * 表示有错误
     */
    public static final String STATE_ERROR = "error";

    /**
     * 表示警告
     */
    public static final String STATE_WARN = "warn";

    private Object data;

    public JSONView() {
    }


    public JSONView(Object data) {
        super();
        this.data = data;
    }

    @Override
    public void render() {

        try {
            getResponse().setHeader("content-type", "text/html; charset=utf-8");
            getResponse().getWriter().print(JSONKit.toJson(data));
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Object getData() {
        return data;
    }

    public void setData(Object data) {
        this.data = data;
    }

}
