package tech.yixiyun.framework.kuafu.view.freemarker;

import freemarker.cache.MruCacheStorage;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;

/**
 * Freemarker辅助工具类，是辅助KuafuFreemarkerServlet使用的，所以必须等FreemarkerServlet初始化完成，
 * 获取到Configuration才能调用各种方法。
 */
public class FreemarkerKit {

    /**
     * 框架用的
     */
    static Configuration cfg =  null;
    /**
     * 初始化配置参数，
     */
    static void initCfgSetting(Configuration c) {
        cfg = c;
    }


    /**
     * 清空模板缓存
     */
    public static void clearTemplateCache() {
        cfg.clearTemplateCache();
    }

    /**
     * 设置模板的缓存数量，默认是一级缓存为0，二级缓存无限大
     * @param l1Count
     * @param l2Count
     */
    public static void setCacheCount(int l1Count, int l2Count) {
        cfg.setCacheStorage(new MruCacheStorage(l1Count, l2Count));
    }


    /**
     * 根据模板和数据生成内容，并且输出到writer中
     * @param path
     * @param data
     * @param writer
     */
    public static void generateAndWrite(String path, Map<String, Object> data, Writer writer) {
        try {
            Template template = cfg.getTemplate(path);
            template.process(data, writer);
        } catch (IOException | TemplateException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 根据模板和数据生成内容
     * @param path
     * @param data
     * @return
     */
    public static String generate(String path, Map<String,Object> data) {
        try(ByteArrayOutputStream bos = new ByteArrayOutputStream()) {
            Writer out = new OutputStreamWriter(bos);
            Template template = cfg.getTemplate(path);
            template.process(data, out);
            String content = new String(bos.toByteArray());
            return content;
        } catch (IOException | TemplateException e) {
            throw new RuntimeException(e);
        }
    }


}
