package tech.yixiyun.framework.kuafu.view.freemarker;

import freemarker.ext.servlet.FreemarkerServlet;
import freemarker.template.TemplateModelException;
import tech.yixiyun.framework.kuafu.config.AppConfig;
import tech.yixiyun.framework.kuafu.config.ConfigKey;

import javax.servlet.ServletException;

/**
 * 处理Freemarker模板的Servlet，
 *
 * @author Yixiyun
 * @version 1.0
 * @date 2021-04-20 18:44
 */
public class KuafuFreemarkerServlet extends FreemarkerServlet {



    @Override
    public void init() throws ServletException {
        super.init();

        //添加个全局变量
        try {
            getConfiguration().setSharedVariable("basePath", AppConfig.getAsString(ConfigKey.SERVER_CONTEXTPATH));
        } catch (TemplateModelException e) {
            e.printStackTrace();
        }


        FreemarkerKit.initCfgSetting(getConfiguration());

    }

}
