/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.modules.entityfile.ui;

import java.io.Serializable;
import java.util.List;
import org.zkoss.zk.ui.event.EventListener;
import tools.dynamia.domain.query.QueryConditions;
import tools.dynamia.domain.util.DomainUtils;
import tools.dynamia.integration.Containers;
import tools.dynamia.modules.entityfile.EntityFileAccountProvider;
import tools.dynamia.modules.entityfile.domain.EntityFile;
import tools.dynamia.modules.entityfile.enums.EntityFileType;
import tools.dynamia.modules.entityfile.service.EntityFileService;
import tools.dynamia.zk.crud.TreeCrudController;
import tools.dynamia.zk.crud.ui.ChildrenLoader;
import tools.dynamia.zk.crud.ui.EntityTreeNode;
import tools.dynamia.zk.crud.ui.LazyEntityTreeNode;

public class EntityFileController
extends TreeCrudController<EntityFile> {
    private EntityFileService service = (EntityFileService)Containers.get().findObject(EntityFileService.class);
    private Object targetEntity;
    private static final long serialVersionUID = 7926996145692421296L;

    public EntityFileController() {
        this.setParentName("parent");
    }

    protected List<EntityFile> loadRoots() {
        return this.service.getEntityFiles(this.targetEntity);
    }

    protected List<EntityFile> loadChildren(EntityFile parentEntity) {
        return this.service.getEntityFiles(this.targetEntity, parentEntity);
    }

    protected void afterCreate() {
        if (this.getSelected() != null && ((EntityFile)this.getSelected()).getType() == EntityFileType.DIRECTORY) {
            ((EntityFile)this.getEntity()).setParent((EntityFile)this.getSelected());
        }
    }

    protected EntityTreeNode<EntityFile> newNode(EntityFile entity) {
        EntityTreeNode node = null;
        switch (entity.getType()) {
            case DIRECTORY: {
                node = new LazyEntityTreeNode((Object)entity, entity.getName(), (ChildrenLoader)this);
                node.setIcon("folder");
                node.setOnOpenListener((EventListener)this);
                break;
            }
            case FILE: 
            case IMAGE: {
                node = new EntityTreeNode((Object)entity, entity.getName());
                node.setIcon(entity.getExtension());
                break;
            }
        }
        return node;
    }

    public void setTargetEntity(Object targetEntity) {
        this.targetEntity = targetEntity;
    }

    public Object getTargetEntity() {
        return this.targetEntity;
    }

    protected void beforeQuery() {
        EntityFileAccountProvider provider;
        if (this.targetEntity != null) {
            this.setParemeter("targetEntity", QueryConditions.eq((Object)this.getTargetEntity().getClass().getName()));
            Serializable id = DomainUtils.findEntityId((Object)this.getTargetEntity());
            if (id instanceof Long) {
                this.setParemeter("targetEntityId", QueryConditions.eq((Object)id));
            } else {
                this.setParemeter("targetEntitySId", QueryConditions.eq((Object)id.toString()));
            }
        }
        if ((provider = (EntityFileAccountProvider)Containers.get().findObject(EntityFileAccountProvider.class)) != null) {
            this.setParemeter("accountId", provider.getAccountId());
        }
    }
}

