/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.modules.entityfile.ui.actions;

import org.springframework.beans.factory.annotation.Autowired;
import tools.dynamia.actions.ActionGroup;
import tools.dynamia.actions.InstallAction;
import tools.dynamia.modules.entityfile.domain.EntityFile;
import tools.dynamia.modules.entityfile.enums.EntityFileType;
import tools.dynamia.modules.entityfile.service.EntityFileService;
import tools.dynamia.modules.entityfile.ui.actions.AbstractEntityFileAction;
import tools.dynamia.modules.entityfile.ui.actions.EntityFileActionEvent;
import tools.dynamia.ui.MessageType;
import tools.dynamia.ui.UIMessages;

@InstallAction
public class DeleteFileAction
extends AbstractEntityFileAction {
    @Autowired
    private EntityFileService service;

    public DeleteFileAction() {
        this.setName("Borrar");
        this.setImage("icons:delete");
        this.setGroup(ActionGroup.get((String)"FILES"));
        this.setMenuSupported(true);
    }

    @Override
    public void actionPerformed(EntityFileActionEvent evt) {
        try {
            EntityFile entityFile = evt.getEntityFile();
            if (entityFile != null) {
                UIMessages.showQuestion((String)("Esta seguro que desea borrar el archivo/directorio " + entityFile.getName() + "?"), () -> {
                    this.service.delete(entityFile);
                    if (entityFile.getType() == EntityFileType.DIRECTORY) {
                        UIMessages.showMessage((String)"Carpeta borrada correctamente");
                    } else {
                        UIMessages.showMessage((String)"Archivo borrado correctamente");
                    }
                    evt.getController().doQuery();
                });
            } else {
                UIMessages.showMessage((String)"Seleccion archivo para borrar", (MessageType)MessageType.WARNING);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            UIMessages.showMessage((String)"Error al borrar archivo", (MessageType)MessageType.ERROR);
        }
    }
}

